// Generated by CoffeeScript 1.7.1
(function() {
  var BrowserWindow, binding, f, fileDialogProperties, k, messageBoxTypes, parseArgs, v8Util, _ref,
    __slice = [].slice,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  binding = process.atomBinding('dialog');

  v8Util = process.atomBinding('v8_util');

  BrowserWindow = require('browser-window');

  fileDialogProperties = {
    openFile: 1 << 0,
    openDirectory: 1 << 1,
    multiSelections: 1 << 2,
    createDirectory: 1 << 3
  };

  messageBoxTypes = ['none', 'info', 'warning'];

  parseArgs = function(window, options, callback) {
    if (!(window === null || (window != null ? window.constructor : void 0) === BrowserWindow)) {
      callback = options;
      options = window;
      window = null;
    }
    if ((callback == null) && typeof options === 'function') {
      callback = options;
      options = null;
    }
    return [window, options, callback];
  };

  module.exports = {
    showOpenDialog: function() {
      var args, callback, options, prop, properties, value, window, wrappedCallback, _ref;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      _ref = parseArgs.apply(null, args), window = _ref[0], options = _ref[1], callback = _ref[2];
      if (options == null) {
        options = {
          title: 'Open',
          properties: ['openFile']
        };
      }
      if (options.properties == null) {
        options.properties = ['openFile'];
      }
      if (!Array.isArray(options.properties)) {
        throw new TypeError('Properties need to be array');
      }
      properties = 0;
      for (prop in fileDialogProperties) {
        value = fileDialogProperties[prop];
        if (__indexOf.call(options.properties, prop) >= 0) {
          properties |= value;
        }
      }
      if (options.title == null) {
        options.title = '';
      }
      if (options.defaultPath == null) {
        options.defaultPath = '';
      }
      if (options.filters == null) {
        options.filters = [];
      }
      wrappedCallback = typeof callback === 'function' ? function(success, result) {
        return callback(success ? result : void 0);
      } : null;
      return binding.showOpenDialog(String(options.title), String(options.defaultPath), options.filters, properties, window, wrappedCallback);
    },
    showSaveDialog: function() {
      var args, callback, options, window, wrappedCallback, _ref;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      _ref = parseArgs.apply(null, args), window = _ref[0], options = _ref[1], callback = _ref[2];
      if (options == null) {
        options = {
          title: 'Save'
        };
      }
      if (options.title == null) {
        options.title = '';
      }
      if (options.defaultPath == null) {
        options.defaultPath = '';
      }
      if (options.filters == null) {
        options.filters = [];
      }
      wrappedCallback = typeof callback === 'function' ? function(success, result) {
        return callback(success ? result : void 0);
      } : null;
      return binding.showSaveDialog(String(options.title), String(options.defaultPath), options.filters, window, wrappedCallback);
    },
    showMessageBox: function() {
      var args, callback, options, window, _ref;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      _ref = parseArgs.apply(null, args), window = _ref[0], options = _ref[1], callback = _ref[2];
      if (options == null) {
        options = {
          type: 'none'
        };
      }
      if (options.type == null) {
        options.type = 'none';
      }
      options.type = messageBoxTypes.indexOf(options.type);
      if (!(options.type > -1)) {
        throw new TypeError('Invalid message box type');
      }
      if (!Array.isArray(options.buttons)) {
        throw new TypeError('Buttons need to be array');
      }
      if (options.title == null) {
        options.title = '';
      }
      if (options.message == null) {
        options.message = '';
      }
      if (options.detail == null) {
        options.detail = '';
      }
      return binding.showMessageBox(options.type, options.buttons, String(options.title), String(options.message), String(options.detail), window, callback);
    }
  };

  _ref = module.exports;
  for (k in _ref) {
    f = _ref[k];
    v8Util.setHiddenValue(f, 'asynchronous', true);
  }

}).call(this);
